<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * SiteController
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class CountryController extends Controller
{
	
    public function actionIndex()
    {
			 $this->layout =   Yii::app()->LayoutClass->layoutpath("map"); 
	 
	 $model = Countries::model()->Countrylist();
	 $this->setData(array(
                    'pageMetaTitle'         => Yii::t('app', '{name} :: home', array('{name}' => Yii::app()->name )), 
                    'pageMetaDescription'   => Yii::app()->params['description'],
                ));
	 $this->render( Yii::app()->LayoutClass->viewpath("index"),compact("model"));
    }
    
    public function actionAddSession($country=null,$state=null)
    {
		unset(Yii::app()->request->cookies['country']);
		unset(Yii::app()->request->cookies['state']);
		unset(Yii::app()->request->cookies['state_name']);
		unset(Yii::app()->request->cookies['country_name']);
		$cookie = new CHttpCookie('country', $country);
		$cookie->expire = time()+60*60*24*180; 
		Yii::app()->request->cookies['country'] = $cookie;
		
		$cookie = new CHttpCookie('state', $state);
		$cookie->expire = time()+60*60*24*180; 
		Yii::app()->request->cookies['state'] = $cookie;
		
		$country_name = Countries::model()->getCountryFromCookie();
		if($country_name)
		{
		$cookie = new CHttpCookie('country_name', $country_name->country_name);
		$cookie->expire = time()+60*60*24*180; 
		Yii::app()->request->cookies['country_name'] = $cookie;
		}
		$state_name = States::model()->getStateFromCookie();
		if($state_name)
		{
		$cookie = new CHttpCookie('state_name', $state_name->state_name);
		$cookie->expire = time()+60*60*24*180; 
		Yii::app()->request->cookies['state_name'] = $cookie;
		}
		else
		{
		$cookie = new CHttpCookie('state_name', 'All Cities('.Yii::app()->request->cookies['country_name'].')');
		$cookie->expire = time()+60*60*24*180; 
		Yii::app()->request->cookies['state_name'] = $cookie;
		}
		  
		  
		$this->redirect(array('site/index'));
		 exit;
		 
	}
	public function actionSession_alter($country=null,$state=null,$return_url)
	{
		 
		unset(Yii::app()->request->cookies['country']);
		unset(Yii::app()->request->cookies['state']);
		unset(Yii::app()->request->cookies['state_name']);
		unset(Yii::app()->request->cookies['country_name']);
		$cookie = new CHttpCookie('country', $country);
		$cookie->expire = time()+60*60*24*180; 
		Yii::app()->request->cookies['country'] = $cookie;
		
		$cookie = new CHttpCookie('state', $state);
		$cookie->expire = time()+60*60*24*180; 
		Yii::app()->request->cookies['state'] = $cookie;
		
		$country_name = Countries::model()->getCountryFromCookie();
		if($country_name)
		{
		$cookie = new CHttpCookie('country_name', $country_name->country_name);
		$cookie->expire = time()+60*60*24*180; 
		Yii::app()->request->cookies['country_name'] = $cookie;
		}
		$state_name = States::model()->getStateFromCookie();
		if($state_name)
		{
		$cookie = new CHttpCookie('state_name', $state_name->state_name);
		$cookie->expire = time()+60*60*24*180; 
		Yii::app()->request->cookies['state_name'] = $cookie;
		}
		else
		{
		$cookie = new CHttpCookie('state_name', 'All Cities('.Yii::app()->request->cookies['country_name'].')');
		$cookie->expire = time()+60*60*24*180; 
		Yii::app()->request->cookies['state_name'] = $cookie;
		}
		$search = new Searchlist();
	    $search=   $search->findByPk($return_url);
	    if($search)
	    {
	    $this->redirect($search->referal);
	    }
	   else
	   {
		    $this->redirect(Yii::app()->createUrl(""));
	   }
	}
    
    public function actionOffline()
    {
        if (Yii::app()->options->get('system.common.site_status') !== 'offline') {
            $this->redirect(array('site/index'));
        }
        
        throw new CHttpException(503, Yii::app()->options->get('system.common.site_offline_message'));
    }
    
    public function actionError()
    {
		 
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest) {
                echo CHtml::encode($error['message']);
            } else {
                $this->setData(array(
                    'pageMetaTitle'         => Yii::t('app', 'Error {code}!', array('{code}' => $error['code'])), 
                    'pageMetaDescription'   => $error['message'],
                ));
                $this->render('error', $error) ;
            }    
        }
    }
 

}
